
#include <stdint.h>
#include <libspe2.h>

/* A 'handle' to the compiled SPE program. This variable is created by
 * the 'embedspu' tool, but just think of it as a program that can be
 * run on an SPE.
 */
extern spe_program_handle_t spe_hello_world;

int main(void)
{
	spe_context_ptr_t ctx;
	uint32_t entry = SPE_DEFAULT_ENTRY;

	/* create a SPE context - the SPE eqivalent of a normal process */
	ctx = spe_context_create(0, NULL);

	/* load the 'spe_hello_world' program into our context */
	spe_program_load(ctx, &spe_hello_world);

	/* run the context */
	spe_context_run(ctx, &entry, 0, NULL, NULL, NULL);

	return 0;
}
