
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <math.h>

#include "parse-fractal.h"

#define streq(a, b) (!strcasecmp(a, b))

struct fractal_params *parse_fractal(const char *filename)
{
	FILE *fp;
	struct fractal_params *fractal;
	char name[7];
	float value;

	fp = fopen(filename, "r");
	if (!fp) {
		fprintf(stderr, "Can't open file %s: %s\n",
				filename, strerror(errno));
		return NULL;
	}

	fractal = malloc(sizeof(*fractal));
	if (!fractal) {
		perror("malloc");
		goto err_close;
	}

	memset(fractal, 0, sizeof(*fractal));

	while (!feof(fp)) {

		int rc = fscanf(fp, "%6s = %f", name, &value);

		if (rc != 2)
			continue;

		if (streq(name, "cols")) {
			fractal->cols = (int)(floor(value));

		} else if (streq(name, "rows")) {
			fractal->rows = (int)(floor(value));

		} else if (streq(name, "x")) {
			fractal->x = value;

		} else if (streq(name, "y")) {
			fractal->y = value;

		} else if (streq(name, "delta")) {
			fractal->delta = value;

		} else if (streq(name, "i_max")) {
			fractal->i_max = value;

		} else {
			fprintf(stderr, "Unknown configutation directive %s\n",
					name);
			goto err_free;
		}
	}

	if (!fractal->cols) {
		fprintf(stderr, "No columns specified in %s\n", filename);
		goto err_free;
	}

	if (!fractal->rows) {
		fprintf(stderr, "No rows specified in %s\n", filename);
		goto err_free;
	}

	if (!fractal->x) {
		fprintf(stderr, "No x value specified in %s\n", filename);
		goto err_free;
	}

	if (!fractal->y) {
		fprintf(stderr, "No y value specified in %s\n", filename);
		goto err_free;
	}

	if (!fractal->delta) {
		fprintf(stderr, "No delta value specified in %s\n", filename);
		goto err_free;
	}

	if (!fractal->i_max) {
		fprintf(stderr, "No i_max value specified in %s\n", filename);
		goto err_free;
	}

	fclose(fp);
	return fractal;

err_free:
	free(fractal);
err_close:
	fclose(fp);
	return NULL;


}
