#ifndef _FRACTAL_H
#define _FRACTAL_H

#include <stdint.h>

struct pixel {
	uint8_t r, g, b, a;
};

struct fractal_params {
	/* the number of rows and columns in the resulting image, in pixels */
	int cols, rows;

	/* the cartesian coordinates of the center of the image */
	float x, y;

	/* per-pixel increment of x and y */
	float delta;

	/* maximum number of iterations */
	int i_max;

	struct pixel *imgbuf;
};

void render_fractal(struct fractal_params *params);

#endif /* _FRACTAL_H */
