
#include "fractal.h"

#define DMA_MAX

/**
 * A temporary buffer to hold generated fractal data, correctly aligned
 */
struct pixel buf[DMA_MAX / sizeof(struct pixel)]
	__attribute__((aligned(SPE_ALIGN)));

/*
 * The argv argument will be populated with the address that the PPE provided,
 * from the 4th argument to spe_context_run()
 */
int main(uint64_t speid, uint64_t argv, uint64_t envp)
{
	struct spe_args args __attribute__((aligned(SPE_ALIGN)));

	/* DMA the spe_args struct into the SPE. The mfc_get function
	 * takes the following arguments, in order:
	 *
	 * - The local buffer pointer to DMA into
	 * - The remote address to DMA from
	 * - A tag (0 to 15) to assign to this DMA transaction. The tag is
	 *   later used to wait for this particular DMA to complete.
	 * - The transfer class ID (don't worry about this one)
	 * - The replacement class ID (don't worry about this one either)
	 */
	mfc_get(&args, argv, sizeof(args), 0, 0, 0);

	/* Wait for the DMA to complete - we write the tag mask with
	 * (1 << tag), where tag is 0 in this case */
	mfc_write_tag_mask(1 << 0);
	mfc_read_tag_status_all();

	/* Generate the fractal, and DMA it back to the PPE */

	return 0;
}
