
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <math.h>

#include "parse-fractal.h"

#define streq(a, b) (!strcasecmp(a, b))

int parse_fractal(const char *filename, struct fractal_params *fractal)
{
	FILE *fp;
	char name[7];
	float value;
	int rc = -1;

	fp = fopen(filename, "r");
	if (!fp) {
		fprintf(stderr, "Can't open file %s: %s\n",
				filename, strerror(errno));
		return -1;
	}

	memset(fractal, 0, sizeof(*fractal));

	while (!feof(fp)) {

		int scan_rc = fscanf(fp, "%6s = %f", name, &value);

		if (scan_rc != 2)
			continue;

		if (streq(name, "cols")) {
			fractal->cols = (int)(floor(value));

		} else if (streq(name, "rows")) {
			fractal->rows = (int)(floor(value));

		} else if (streq(name, "x")) {
			fractal->x = value;

		} else if (streq(name, "y")) {
			fractal->y = value;

		} else if (streq(name, "delta")) {
			fractal->delta = value;

		} else if (streq(name, "i_max")) {
			fractal->i_max = value;

		} else {
			fprintf(stderr, "Unknown configutation directive %s\n",
					name);
			goto out_close;
		}
	}

	if (!fractal->cols) {
		fprintf(stderr, "No columns specified in %s\n", filename);
		goto out_close;
	}

	if (!fractal->rows) {
		fprintf(stderr, "No rows specified in %s\n", filename);
		goto out_close;
	}

	if (!fractal->x) {
		fprintf(stderr, "No x value specified in %s\n", filename);
		goto out_close;
	}

	if (!fractal->y) {
		fprintf(stderr, "No y value specified in %s\n", filename);
		goto out_close;
	}

	if (!fractal->delta) {
		fprintf(stderr, "No delta value specified in %s\n", filename);
		goto out_close;
	}

	if (!fractal->i_max) {
		fprintf(stderr, "No i_max value specified in %s\n", filename);
		goto out_close;
	}

	rc = 0;

out_close:
	fclose(fp);
	return rc;


}
