/**
 * Common definitions for the fractal renderer. These are shared
 * between PPE and SPE.
 */
#ifndef _FRACTAL_H
#define _FRACTAL_H

#include <stdint.h>

#define SPE_ALIGN 0x80

struct pixel {
	uint8_t r, g, b, a;
};

struct fractal_params {
	/* the number of rows and columns in the resulting image, in pixels */
	int cols, rows;

	/* the cartesian coordinates of the center of the image */
	float x, y;

	/* per-pixel increment of x and y */
	float delta;

	/* maximum number of iterations to test */
	int i_max, alpha;

	/* the image: an array of rows * cols elements of struct pixels */
	struct pixel *imgbuf;
};

/**
 * This structure is used to DMA arguments to a new SPE thread.
 * Put any data here that will need to be passed to the SPE. Maybe
 * fractal parmeters? buffer addresses?
 */
struct spe_args {


} __attribute__((aligned(SPE_ALIGN)));


#endif /* _FRACTAL_H */
