#include <stdint.h>
#include <stdlib.h>
#include <libspe2.h>
#include <pthread.h>
#include <malloc.h>
#include <unistd.h>
#include <string.h>

#include "fractal.h"
#include "png.h"
#include "parse-fractal.h"

#define DEFAULT_PARAMSFILE "fractal.data"
#define DEFAULT_OUTFILE "fractal.png"

extern spe_program_handle_t spe_fractal;

struct spe_thread {
	spe_context_ptr_t ctx;
	pthread_t pthread;
	struct spe_args args __attribute__((aligned(SPE_ALIGN)));
};

/**
 * This function is called in a new thread - use it to contain your
 * SPE-running functions.
 */
void *spethread_fn(void *data)
{
	struct spe_thread *spethread = data;
}

int main(int argc, char **argv)
{
	int n_threads;
	struct fractal_params fractal;
	const char *outfile, *paramsfile;
	int opt;

	/* set up default arguments */
	paramsfile = DEFAULT_PARAMSFILE;
	outfile = DEFAULT_OUTFILE;
	n_threads = 8;

	/* parse arguments into datafile and outfile  */
	while ((opt = getopt(argc, argv, "p:o:n:")) != -1) {
		switch (opt) {
		case 'p':
			paramsfile = optarg;
			break;
		case 'o':
			outfile = optarg;
			break;
		case 'n':
			n_threads = atoi(optarg);
			break;
		default:
			fprintf(stderr, "Usage: %s [-p paramsfile] "
						"[-o outfile]\n", argv[0]);
			return EXIT_FAILURE;
		}
	}

	/* parse the input datafile */
	if (parse_fractal(paramsfile, &fractal))
		return EXIT_FAILURE;

	/* generate your fractal, based on the parms in the 'fractal' var */

	/* compress and write to outfile */
	if (write_png(outfile, fractal.rows, fractal.cols, fractal.imgbuf))
		return EXIT_FAILURE;

	return 0;
}
