#!/usr/bin/env python

from setuptools import setup

setup(name = 'hiprofile',
        version = '1.0',
        license = 'GPL',
        description = 'HTML interactive profile report generator',
        url = 'http://ozlabs.org/~jk/projects/hiprofile/',
        author = 'Jeremy Kerr',
        author_email = 'jk@ozlabs.org',
        requires = ['jinja2'],
        packages = ['hiprofile'],
        scripts = ['scripts/hiprofile'],
        package_data = {'hiprofile':
                        ['resources/base.html',
                         'resources/report.html',
                         'resources/binary.html',
                         'resources/symbol.html',
                         'resources/style.css',
                         'resources/bar.png',
                         'resources/hiprofile.js',
                         'resources/jquery-1.3.1.min.js'],
                     }
        )
