/*
 * feedbackd - dynamic feedback system for LVS
 * Copyright (C) 2007 Jeremy Kerr
 * 
 * This file is part of feedbackd.
 *
 *  feedbackd is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  feedbackd is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with feedbackd; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**
 * @file utils.h
 * generic (common) utils
 */

#ifndef UTILS_H
#define UTILS_H

#define streq(a,b) (!strcmp(a,b))

/**
 * Parse a number into an int, handling errors.
 *
 * @param val[out] The value to populate with the parsed number, not altered
 * 		   if parsing failed
 * @param str The string to parse as a number
 * @param max The maximum value to accept
 * @param description A description of the value to parse, used for logging.
 * 		      if NULL, no message is logged
 * @return zero on success, non-zero on failure
 */
int parse_number(int *val, const char *str, int max, const char *description);

#endif /* UTILS_H */
