/*
 * feedbackd - dynamic feedback system for LVS
 * Copyright (C) 2007 Jeremy Kerr
 * 
 * This file is part of feedbackd.
 *
 *  feedbackd is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  feedbackd is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with feedbackd; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <errno.h>
#include <stdlib.h>

#include "log.h"


int parse_number(int *val, const char *str, int max, const char *description)
{
	int tmp;
	char *end;
	errno = 0;

	tmp = strtoul(str, &end, 0);
	if (*end != '\0' || end == str) {
		if (description)
			log_printf(LOG_ERR, "Invalid value (%s) given for %s, "
					"expected a number", str, description);
		return 1;
	}

	if (errno == ERANGE || tmp > max) {
		if (description)
			log_printf(LOG_ERR, "Invalid value (%s) given for %s, "
					"number too large", str, description);
		return 1;
	}

	*val = tmp;
	return 0;
}

