/*
 * feedbackd - dynamic feedback system for LVS
 * Copyright (C) 2002 Jeremy Kerr
 *
 * This file is part of feedbackd.
 *
 *  feedbackd is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  feedbackd is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with feedbackd; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**
 * @file plugin.h
 *
 * Header file for feedbackd-agent plugins
 */

#ifndef PLUGIN_H
#define PLUGIN_H

#include "log.h"
#include "feedbackd-agent.h"

struct monitor {
	int	(*config)(struct monitor *monitor, char *name, char *value);
	int	(*init)(struct monitor *monitor);
	int	(*get_health)(struct monitor *monitor);
	int	(*destroy)(struct monitor *monitor);
};

#define plugin_printf(level, name, fmt, ...) \
	log_printf(level, "[plugin:" #name "] " fmt, ## __VA_ARGS__)

#endif /* PLUGIN_H */
