/*
 * feedbackd - dynamic feedback system for LVS
 * Copyright (C) 2002 Jeremy Kerr
 * 
 * This file is part of feedbackd.
 *
 *  feedbackd is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  feedbackd is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with feedbackd; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**
 * @file constant.c
 *
 * Sample load reporting plugin.
 */

#include <string.h>
#include <errno.h>
#include <stdlib.h>

#include "plugin.h"
#include "utils.h"
#include "log.h"
#include "feedbackd-agent.h"

struct constant_monitor {
	struct monitor	base;
	int		health;
	int		configured;
};

static int config(struct monitor *monitor, char *name, char *value)
{
	struct constant_monitor *cm = (struct constant_monitor *)monitor;

	if (!streq(name, "value")) {
		plugin_printf(LOG_ERR, constant, "Unknown configuration "
				"directive %s", name);
		return -1;
	}

	if (parse_number(&cm->health, value, 100, "value"))
		return -1;

	cm->configured = 1;

	return 0;
}

static int init(struct monitor *monitor)
{
	struct constant_monitor *cm = (struct constant_monitor *)monitor;
	if (!cm->configured) {
		plugin_printf(LOG_ERR, constant, "No value given for health");
		return -1;
	}
	return 0;
}

static int get_health(struct monitor *monitor)
{
	struct constant_monitor *cm = (struct constant_monitor *)monitor;
	return cm->health;
}

static int destroy(struct monitor *monitor)
{
	free(monitor);
	return 0;
}

struct monitor *create_monitor(struct service *service)
{
	struct constant_monitor *monitor;

	monitor = malloc(sizeof(*monitor));
	if (!monitor)
		return NULL;
	memset(monitor, 0, sizeof(monitor));

	monitor->base.config     = config;
	monitor->base.init       = init;
	monitor->base.get_health = get_health;
	monitor->base.destroy    = destroy;

	return (struct monitor *)monitor;
}
