/*
 * feedbackd - dynamic feedback system for LVS
 * Copyright (C) 2002 Jeremy Kerr
 * 
 * This file is part of feedbackd.
 *
 *  feedbackd is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  feedbackd is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with feedbackd; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**
 * @file necp_listener.h
 * NECP listener.
 *
 * Provides the main network to NECP functionality - handles new and
 * existing connections, and keeps track of the server table.
 *
 */

#ifndef __HAVE_NECP_LISTENER_H
#define __HAVE_NECP_LISTENER_H 1

#include "feedbackd-master.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

/**
 * Boolean for running state. If this is set to false necp_listen will return
 * after the next select() is completed.
 */
int necp_listener_running;

/**
 * Main server loop. Establishes a main socket descriptor, and uses select() to
 * listen on each socket descriptor.
 */
void necp_listen(void);

/**
 * Handle incoming data from a server. a few sanity checks are done on the
 * data, and handle_necp_data() is called.
 *
 * @param serverp pointer to the server structure the data
 *                 was received from
 */
void data_from_server(struct server *serverp);

struct server *free_server_slot(void);
/**
 * Closes the TCP connection to a server.
 * 
 * @param serverp A pointer to the server object to disconnect
 */
void disconnect_server(struct server *serverp);

/**
 * Sends a NECP packet to a server.
 *
 * @param serverp A pointer to the server structure to send the packet to
 * @param packet The packet to send
 */
int send_packet(struct server *serverp, char *packet);

#endif /* __HAVE_NECP_LISTENER_H */
