/*
 * feedbackd - dynamic feedback system for LVS
 * Copyright (C) 2002 Jeremy Kerr
 *
 * This file is part of feedbackd.
 *
 *  feedbackd is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  feedbackd is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with feedbackd; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**
 * @file necp_client.h
 *
 * NECP processing functions
 */

#ifndef __HAVE_NECP_CLIENT_H
#define __HAVE_NECP_CLIENT_H 1

#include <inttypes.h>

#include "feedbackd-agent.h"

uint64_t seq_sent;	/**< The last sequence number sent */
uint64_t seq_expected;	/**< The next sequence number expected */
uint32_t request_id;	/**< The last request id sent */

/**
 * Data is available on the socket, read and take action
 *
 * @param sd the socket descriptor to listen on
 * @return 0 if the data was read and parsed correctly,
 *         non-zero otherwise
 */
int data_received(int sd);


/**
 * Initialise the NECP process (send a NECP_INIT) packet
 *
 * @param sd the socket descriptor to send on
 */
int necp_init(int sd);


/**
 * Start directing traffic to this node for a particular service (ie, send a NECP_START
 * packet to the director)
 *
 * @param sd the socket descriptor to send on
 * @return 0 if the service was started correctly, non-zero
 *         otherwise
 */
int necp_start(int sd);

/**
 * Stop directing traffic to this node for a particular service
 *
 * @param sd the socket descriptor to send on
 * @return 0 if the service was started correctly, non-zero
 *         otherwise
 */
int necp_stop(int sd);

/**
 * Send a NECP keepalive on sd, with reference to the keepalive packet received.
 *
 * @param sd the socket descriptor to send on
 * @param packet the keepalive packet received
 * @return 0 if the packet was sent sucessfully, non-zero otherwise.
 */
int necp_keepalive(int sd, char *packet);

/**
 * Send a NECP packet. Does all the global-packet stuff, like setting protocol id,
 * sequence no. and version.
 *
 * @param sd the socket descriptor to send on
 * @param packet the packet to send
 * @return 0 if the service was started correctly, non-zero
 *         otherwise
 */
int send_packet(int sd, char *packet);

#endif /* __HAVE_NECP_CLIENT_H */
