/*
 * feedbackd - dynamic feedback system for LVS
 * Copyright (C) 2002 Jeremy Kerr
 * 
 * This file is part of feedbackd.
 *
 *  feedbackd is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  feedbackd is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with feedbackd; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**
 * @file necp.c
 */

#include "necp.h"

#include <stdio.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_ENDIAN_H
#include <endian.h>
#elif defined(HAVE_SYS_ENDIAN_H)
#include <sys/endian.h>
#endif

#include <netinet/in.h>

#define htonll ntohll

static inline uint64_t ntohll(uint64_t x)
{
#if __BYTE_ORDER == __LITTLE_ENDIAN
	uint32_t h, l;

	h = x >> 32;
	l = x & 0x00000000ffffffff;

	return (((uint64_t)ntohl(l)) << 32) | ntohl(h);
#else
	return x;
#endif
}

/* these should be completely optimised out on a big-endian machine */
inline void prepare_header_in(struct necp_header *header)
{
	header->protocol_identifier = ntohs(header->protocol_identifier);
	header->flags               = ntohs(header->flags);
	header->request_id          = ntohs(header->request_id);
	header->seq_num             = ntohll(header->seq_num);
	header->payload_len         = ntohl(header->payload_len);
}

inline void prepare_header_out(struct necp_header *header)
{
	header->protocol_identifier = htons(header->protocol_identifier);
	header->flags               = htons(header->flags);
	header->request_id          = htons(header->request_id);
	header->seq_num             = htonll(header->seq_num);
	header->payload_len         = htonl(header->payload_len);
}

