/*
 * feedbackd - dynamic feedback system for LVS
 * Copyright (C) 2002 Jeremy Kerr
 *
 * This file is part of feedbackd.
 *
 *  feedbackd is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  feedbackd is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with feedbackd; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**
 * @file log.h
 *
 * logging functions for the feedbackd sytem
 */

#ifndef HAVE_LOG_H
#define HAVE_LOG_H 1

#include <stdarg.h>

/* if this is longer than 30 chars, update log.c */
#define TIMEFMT "[%d/%b/%Y %H:%M:%S] "

/**
 * Log level options
 */
typedef enum {
	LOG_CRIT	= 1, /**< Critical Errors */
	LOG_ERR		= 2, /**< Errors */
	LOG_WARN	= 3, /**< Warnings */
	LOG_INFO	= 4, /**< Information */
	LOG_DEBUG	= 5, /**< Debugging */
	LOG_VDEBUG	= 6  /**< Debugging, with packet data */
} loglevel;

/**
 * Log text to the logfile.
 *
 * @param level the level to log at. If the current log level is less than
 *        level, then the text is discarded
 * @param format the string to log
 * @param ... format elements
 */
void log_printf(loglevel level, const char *format, ...);

/**
 * Stop logging and close the log files
 */
void log_stop(void);

int log_setfile(const char *file);
int log_setlevel(const char *level);

#endif /* HAVE_LOG_H */
