/*
 * feedbackd - dynamic feedback system for LVS
 * Copyright (C) 2002 Jeremy Kerr
 * 
 * This file is part of feedbackd.
 *
 *  feedbackd is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  feedbackd is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with feedbackd; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**
 * @file linkedlist.c
 * Simple implementation of a linked list.
 */

#include "linkedlist.h"

#include <stdlib.h>
#include <assert.h>
#include <stdio.h>

void list_init(list *list)
{
	list->head = NULL;
	list->count = 0;
}
	

int list_add(list *list, void *item)
{
	listitem *new;

	assert(list);
	assert(item);

	if (!(new = malloc(sizeof(listitem)))) {
		perror("malloc");
		return -1;
	}
	new->item = item;
	new->next = list->head;
	list->head = new;
	list->count++;
	
	return 0;
}

int list_add_ordered(list *list, void *item, int comp(void *, void *))
{	
	listitem *new, **cur;

	assert(list);
	assert(item);
	assert(comp);

	if (!(new = malloc(sizeof(listitem)))) {
		perror("malloc");
		return -1;
	}
	new->item = item;

	cur = &(list->head);

	while (*cur && comp(item, (*cur)->item) > 0) {
		cur = &((*cur)->next);
	}

	new->next = *cur;
	*cur = new;
	list->count ++;

	return 0;
	
}

int list_remove(list *list, void *item)
{
	listitem **cur = &(list->head);
	
	assert(list);
	assert(item);
	
	while (cur) {
		if ((*cur)->item == item) {
			listitem *tmp = *cur;
			*cur = (*cur)->next;
			free(tmp);
			list->count--;
			return 0;
		}
		cur = &((*cur)->next);
	}
	return -1;
}
